﻿var publishItem = {
    context: $(".v-publishItem"),
    initializeAutoCompletes: function () {
        var portalId = $("#PortalId", publishItem.context).val();

        $("#PortalName", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetPortalsForAutoComplete", "Project", "Reporting"),
            altValueField: $("#PortalId", publishItem.context),            
            select: function (event, data) {
                var subscribersAutocomplete = $("#SubscriberName", publishItem.context);

                if (data && data.item) {
                    publishItem.setSubscribersAutocomplete(data.item.Value, $("#SubscriberType:checked", publishItem.context).val());

                    $(".v-subscriberType", publishItem.context).prop("disabled", false);
                    subscribersAutocomplete.a4autocomplete("enable");
                }
                else {
                    $(".v-subscriberType", publishItem.context).prop("disabled", true);
                    $("#SubscriberId", publishItem.context).val("");
                    subscribersAutocomplete.a4autocomplete("disable");
                    subscribersAutocomplete.val("");
                }
            }
        });

        if (portalId) {
            publishItem.setSubscribersAutocomplete(portalId, $("#SubscriberType:checked", publishItem.context).val());
        }

        publishItem.setItemsAutocomplete($("#ItemType:checked", publishItem.context).val());
    },
    setSubscribersAutocomplete: function (portalId, subscriberType) {
        var method = subscriberType == "User" ? "GetUsersForAutoComplete" : "GetGroupsForAutoComplete";
        var autocomplete = $("#SubscriberName", this.context);

        if (autocomplete.hasClass("autocomplete")) {
            $("#SubscriberId", publishItem.context).val("");
            autocomplete.val("");
            autocomplete.a4autocomplete("destroy");
        }

        autocomplete.a4autocomplete({
            ajaxAction: a4.getAction(method, "Project", "Reporting"),
            ajaxParams: { portalId: portalId },            
            altValueField: $("#SubscriberId", publishItem.context)
        });
    },
    setItemsAutocomplete: function (itemType) {
        var action;
        var valueProperty = "Value";
        var labelProperty = "Label";
        var autocomplete = $("#ItemName", this.context);

        switch (itemType) {            
            case "Report":
                action = a4.getAction("GetReportsForAutoComplete", "Project", "Reporting");
                valueProperty = "Id";
                labelProperty = "Name";
                break;
            case "ReportFolder":
                action = a4.getAction("GetReportFolders", "Project", "Reporting");
                valueProperty = "Id";
                labelProperty = "Name";
                break;
            case "Project":
                action = a4.getAction("GetProjectsForAutocomplete", "Home", "Project");
                valueProperty = "Id";
                labelProperty = "Name";
                break;
            case "ProjectFolder":
                action = a4.getAction("GetProjectFolders", "Home", "Project");
                valueProperty = "Id";
                labelProperty = "Name";
                break;
        }

        if (autocomplete.hasClass("autocomplete")) {
            autocomplete.a4autocomplete("clearValue");
            autocomplete.a4autocomplete("destroy");
        }

        autocomplete.a4autocomplete({
            ajaxAction: action,
            valueProperty: valueProperty,
            labelProperty: labelProperty,
            altValueField: $("#ItemId", publishItem.context)
        });
    },
    bindEvents: function () {
        this.context.on("change", "#SubscriberType", function () {
            var portalId = $("#PortalId", publishItem.context).val();
            if (portalId) {
                publishItem.setSubscribersAutocomplete(portalId, $(this).val());
            }
        });

        this.context.on("change", "#ItemType", function () {
            publishItem.setItemsAutocomplete($(this).val());
        });
    }
}

$(document).ready(function () {
    if (publishItem.context.length > 0) {
        publishItem.bindEvents();
        publishItem.initializeAutoCompletes();
    }
});